// Navigation and Section Scrolling Logic
document.addEventListener("DOMContentLoaded", function () {
  if (typeof jQuery === "undefined") {
    console.warn("jQuery is not loaded. Navigation script skipped.");
    return;
  }

  var $ = jQuery;
  $(".nav li:first").addClass("active");

  var showSection = function (section, isAnimate) {
    var direction = section.replace(/#/, "");
    var reqSection = $(".section").filter('[data-section="' + direction + '"]');
    if (reqSection.length === 0) return;

    var reqSectionPos = reqSection.offset().top-0;

    if (isAnimate) {
      $("body, html").animate({ scrollTop: reqSectionPos }, 800);
    } else {
      $("body, html").scrollTop(reqSectionPos);
    }
  };

  var checkSection = function () {
    $(".section").each(function () {
      var $this = $(this),
        topEdge = $this.offset().top-80,
        bottomEdge = topEdge + $this.height(),
        wScroll = $(window).scrollTop();

      if (topEdge < wScroll && bottomEdge > wScroll) {
        var currentId = $this.data("section"),
          reqLink = $("a").filter("[href*=\\#" + currentId + "]");

        reqLink
          .closest("li")
          .addClass("active")
          .siblings()
          .removeClass("active");
      }
    });
  };

  $(".main-menu, .responsive-menu, .scroll-to-section").on(
    "click",
    "a",
    function (e) {
      var href = $(this).attr("href");
      if (href && href.startsWith("#")) {
        e.preventDefault();
        showSection(href, true);
      }
    }
  );

  $(window).scroll(function () {
    checkSection();
  });
});
