document.addEventListener("DOMContentLoaded", function () {
  // Check local storage or default to 'en'
  const currentLang = localStorage.getItem("language") || "ar";
  applyLanguage(currentLang);

  // Find the toggle button
  const langBtn = document.getElementById("language-toggle");
  if (langBtn) {
    langBtn.addEventListener("click", function (e) {
      e.preventDefault();
      toggleLanguage();
    });
    updateButtonText(currentLang);
  }
});

function toggleLanguage() {
  const currentLang = document.documentElement.getAttribute("lang") || "en";
  const newLang = currentLang === "en" ? "ar" : "en";

  applyLanguage(newLang);
  localStorage.setItem("language", newLang);
  updateButtonText(newLang);
}

function applyLanguage(lang) {
  const html = document.documentElement;
  html.setAttribute("lang", lang);

  if (lang === "ar") {
    html.setAttribute("dir", "rtl");
  } else {
    html.setAttribute("dir", "ltr");
  }

  // Reinitialize carousels with RTL support
  if (typeof $ !== "undefined" && $.fn.owlCarousel) {
    setTimeout(function () {
      // Service carousel
      var $serviceCarousel = $(".owl-service-item");
      if ($serviceCarousel.length) {
        $serviceCarousel.trigger("destroy.owl.carousel");
        $serviceCarousel.owlCarousel({
          items: 3,
          loop: true,
          dots: true,
          nav: true,
          autoplay: true,
          margin: 30,
          rtl: lang === "ar",
          responsive: {
            0: { items: 1 },
            600: { items: 2 },
            1000: { items: 3 },
          },
        });
      }

      // Courses carousel
      var $coursesCarousel = $(".owl-courses-item");
      if ($coursesCarousel.length) {
        $coursesCarousel.trigger("destroy.owl.carousel");
        $coursesCarousel.owlCarousel({
          items: 4,
          loop: true,
          dots: true,
          nav: true,
          autoplay: true,
          margin: 30,
          rtl: lang === "ar",
          responsive: {
            0: { items: 1 },
            600: { items: 2 },
            1000: { items: 4 },
          },
        });
      }
    }, 100);
  }
}

function updateButtonText(lang) {
  const langBtn = document.getElementById("language-toggle");
  if (langBtn) {
    // If current is English, show option to switch to Arabic, and vice versa
    langBtn.textContent = lang === "en" ? "العربية" : "English";
  }
}
