﻿(function ($) {
  "use strict";

  $(window).scroll(function () {
    var scroll = $(window).scrollTop();

    if (scroll >= 50) {
      $("header").addClass("background-header");
    } else {
      $("header").removeClass("background-header");
    }
  });

  $(".filters ul li").click(function () {
    $(".filters ul li").removeClass("active");
    $(this).addClass("active");

    var data = $(this).attr("data-filter");
    $grid.isotope({
      filter: data,
    });
  });

  var $grid = $(".grid").isotope({
    itemSelector: ".all",
    percentPosition: true,
    masonry: {
      columnWidth: ".all",
    },
  });

  const Accordion = {
    settings: {
      // Expand the first item by default
      first_expanded: false,
      // Allow items to be toggled independently
      toggle: false,
    },

    openAccordion: function (toggle, content) {
      if (content.children.length) {
        toggle.classList.add("is-open");
        let final_height = Math.floor(content.children[0].offsetHeight);
        content.style.height = final_height + "px";
      }
    },

    closeAccordion: function (toggle, content) {
      toggle.classList.remove("is-open");
      content.style.height = 0;
    },

    init: function (el) {
      const _this = this;

      // Override default settings with classes
      let is_first_expanded = _this.settings.first_expanded;
      if (el.classList.contains("is-first-expanded")) is_first_expanded = true;
      let is_toggle = _this.settings.toggle;
      if (el.classList.contains("is-toggle")) is_toggle = true;

      // Loop through the accordion's sections and set up the click behavior
      const sections = el.getElementsByClassName("accordion");
      const all_toggles = el.getElementsByClassName("accordion-head");
      const all_contents = el.getElementsByClassName("accordion-body");
      for (let i = 0; i < sections.length; i++) {
        const section = sections[i];
        const toggle = all_toggles[i];
        const content = all_contents[i];

        // Click behavior
        toggle.addEventListener("click", function (e) {
          if (!is_toggle) {
            // Hide all content areas first
            for (let a = 0; a < all_contents.length; a++) {
              _this.closeAccordion(all_toggles[a], all_contents[a]);
            }

            // Expand the clicked item
            _this.openAccordion(toggle, content);
          } else {
            // Toggle the clicked item
            if (toggle.classList.contains("is-open")) {
              _this.closeAccordion(toggle, content);
            } else {
              _this.openAccordion(toggle, content);
            }
          }
        });

        // Expand the first item
        if (i === 0 && is_first_expanded) {
          _this.openAccordion(toggle, content);
        }
      }
    },
  };

  (function () {
    // Initiate all instances on the page
    const accordions = document.getElementsByClassName("accordions");
    for (let i = 0; i < accordions.length; i++) {
      Accordion.init(accordions[i]);
    }
  })();

  $(".owl-service-item").owlCarousel({
    rtl: true,
    items: 3,
    loop: true,
    dots: true,
    nav: true,
    autoplay: true,
    margin: 30,
    responsive: {
      0: {
        items: 1,
      },
      600: {
        items: 2,
      },
      1000: {
        items: 3,
      },
    },
  });

  $(".owl-courses-item").owlCarousel({
    rtl: true,
    items: 4,
    loop: true,
    dots: true,
    nav: true,
    autoplay: true,
    margin: 30,
    responsive: {
      0: {
        items: 1,
      },
      600: {
        items: 2,
      },
      1000: {
        items: 4,
      },
    },
  });

  // Mobile Sidebar Toggle
  const mobileTrigger = $("#mobile-trigger");
  const closeSidebar = $("#close-sidebar");
  const sidebar = $("#mobile-sidebar");
  const overlay = $("#sidebar-overlay");

  function toggleSidebar() {
    sidebar.toggleClass("active");
    overlay.toggleClass("active");
    $("body").toggleClass("sidebar-open");
  }

  mobileTrigger.on("click", function (e) {
    e.preventDefault();
    toggleSidebar();
  });

  closeSidebar.on("click", toggleSidebar);
  overlay.on("click", toggleSidebar);

  // Sidebar Submenu Toggle
  $(".has-sub-sidebar > .dropdown-toggle").on("click", function (e) {
    e.preventDefault();
    const parent = $(this).parent(".has-sub-sidebar");
    parent.toggleClass("open");
    parent.find(".sidebar-submenu").slideToggle(300);

    // Close other submenus
    parent
      .siblings(".has-sub-sidebar")
      .removeClass("open")
      .find(".sidebar-submenu")
      .slideUp(300);
  });

  // Close sidebar on link click (for in-page links)
  $(".sidebar-link:not(.dropdown-toggle)").on("click", function () {
    if (sidebar.hasClass("active")) {
      toggleSidebar();
    }
  });

  // Normalize links like "/#top" to safe in-page scroll before other handlers run
  $(document).on("click", 'a[href^="/#"]', function (e) {
    var rawHash = this.hash || "";
    if (!rawHash || rawHash === "#") {
      return;
    }
    var id = rawHash.slice(1);
    var el = document.getElementById(id) || document.getElementsByName(id)[0];
    if (!el) {
      // If element doesn't exist on current page, let the browser navigate to the home page
      return;
    }
    e.preventDefault();
    $("html,body").animate(
      {
        scrollTop: $(el).offset().top - 80,
      },
      700
    );
  });

  // Menu elevator animation
  $(".scroll-to-section a[href*=\\#]:not([href=\\#])").on("click", function () {
    if (
      location.pathname.replace(/^\//, "") ==
        this.pathname.replace(/^\//, "") &&
      location.hostname == this.hostname
    ) {
      var rawHash = this.hash || "";
      if (!rawHash || rawHash === "#") {
        return false;
      }
      var id = rawHash.slice(1);
      var el = document.getElementById(id) || document.getElementsByName(id)[0];
      if (el) {
        var $target = $(el);
        var width = $(window).width();
        if (width < 991) {
          $(".menu-trigger").removeClass("active");
          $(".header-area .nav").slideUp(200);
        }
        $("html,body").animate(
          {
            scrollTop: $target.offset().top - 80,
          },
          700
        );
        return false;
      }
    }
  });

  $(document).ready(function () {
    $(document).on("scroll", onScroll);

    //smoothscroll
    $('.scroll-to-section a[href^="#"]').on("click", function (e) {
      e.preventDefault();
      $(document).off("scroll");

      $(".scroll-to-section a").each(function () {
        $(this).removeClass("active");
      });
      $(this).addClass("active");

      var rawHash = this.hash || "";
      var id = rawHash.slice(1);
      var el = document.getElementById(id) || document.getElementsByName(id)[0];
      if (!el) {
        return;
      }
      var $target = $(el);
      $("html, body")
        .stop()
        .animate(
          {
            scrollTop: $target.offset().top - 79,
          },
          500,
          "swing",
          function () {
            window.location.hash = rawHash;
            $(document).on("scroll", onScroll);
          }
        );
    });
  });

  function onScroll(event) {
    var scrollPos = $(document).scrollTop();
    // عالج فقط الروابط التي تحتوي على # لتفادي '/#...'
    $('.nav a[href*="#"]').each(function () {
      var currLink = $(this);
      var href = currLink.attr("href") || "";
      // استخدم الجزء الذي بعد # فقط لتفادي أخطاء مثل "/#top"
      var hashIndex = href.indexOf("#");
      if (hashIndex === -1) {
        currLink.removeClass("active");
        return; // لا يوجد مرجع لقسم في الصفحة
      }
      var hash = href.slice(hashIndex);
      if (!hash || hash === "#") {
        currLink.removeClass("active");
        return;
      }
      // استخدام DOM مباشر بدلاً من jQuery selectors لتفادي '/#top'
      var id = hash.slice(1);
      var el = document.getElementById(id);
      if (!el) {
        currLink.removeClass("active");
        return;
      }
      // حسابات موضع العنصر بدون jQuery
      var rect = el.getBoundingClientRect();
      var refTop = rect.top + window.pageYOffset;
      var refHeight = el.offsetHeight;
      if (refTop <= scrollPos && refTop + refHeight > scrollPos) {
        $(".nav ul li a").removeClass("active");
        currLink.addClass("active");
      } else {
        currLink.removeClass("active");
      }
    });
  }

  // Page loading animation
  $(window).on("load", function () {
    if ($(".cover").length) {
      $(".cover").parallax({
        imageSrc: $(".cover").data("image"),
        zIndex: "1",
      });
    }

    $("#preloader").animate(
      {
        opacity: "0",
      },
      600,
      function () {
        setTimeout(function () {
          $("#preloader").css("visibility", "hidden").fadeOut();
        }, 300);
      }
    );
  });

  const dropdownOpener = $(".main-nav ul.nav .has-sub > a");

  // Open/Close Submenus
  if (dropdownOpener.length) {
    dropdownOpener.each(function () {
      var _this = $(this);

      _this.on("tap click", function (e) {
        var thisItemParent = _this.parent("li"),
          thisItemParentSiblingsWithDrop = thisItemParent.siblings(".has-sub");

        if (thisItemParent.hasClass("has-sub")) {
          var submenu = thisItemParent.find("> ul.sub-menu");

          if (submenu.is(":visible")) {
            submenu.slideUp(450, "easeInOutQuad");
            thisItemParent.removeClass("is-open-sub");
          } else {
            thisItemParent.addClass("is-open-sub");

            if (thisItemParentSiblingsWithDrop.length === 0) {
              thisItemParent
                .find(".sub-menu")
                .slideUp(400, "easeInOutQuad", function () {
                  submenu.slideDown(250, "easeInOutQuad");
                });
            } else {
              thisItemParent
                .siblings()
                .removeClass("is-open-sub")
                .find(".sub-menu")
                .slideUp(250, "easeInOutQuad", function () {
                  submenu.slideDown(250, "easeInOutQuad");
                });
            }
          }
        }

        e.preventDefault();
      });
    });
  }

  function visible($t, partial = false) {
    if (!$t || !$t.length) return false; // ✅ حماية

    var $w = jQuery(window),
      viewTop = $w.scrollTop(),
      viewBottom = viewTop + $w.height(),
      _top = $t.offset().top,
      _bottom = _top + $t.outerHeight(),
      compareTop = partial ? _bottom : _top,
      compareBottom = partial ? _top : _bottom;

    return (
      compareBottom <= viewBottom && compareTop >= viewTop && $t.is(":visible")
    );
  }

  $(window).on("scroll", function () {
    var $digits = $(".count-digit");

    if (!$digits.length) return; // ✅ لا يوجد عداد

    if (visible($digits)) {
      if ($digits.hasClass("counter-loaded")) return;

      $digits.addClass("counter-loaded");

      $digits.each(function () {
        var $this = $(this);
        jQuery({ Counter: 0 }).animate(
          { Counter: $this.text() },
          {
            duration: 3000,
            easing: "swing",
            step: function () {
              $this.text(Math.ceil(this.Counter));
            },
          }
        );
      });
    }
  });
})(window.jQuery);
